# -*- coding: cp1252 -*-
import wx
import os
from random import choice
from normalisation import *

class MaFenetre(wx.Frame):
  nbr_questions = 0
  bonnes_reponses = 0
  questions = []
  chances_restantes = 2
 
  def __init__(self, parent, id, titre):
      wx.Frame.__init__(self, parent, id, titre)
      # Prparation du menu
      barre_menu = wx.MenuBar()
      # On part de la gauche ... 
      sous_menu = wx.Menu()
      sous_menu.Append(101, "Autre &Questionnaire")
      sous_menu.AppendSeparator()
      sous_menu.Append(102, "&Sortie")
      # On ajoute le sous-menu  la barre de menu
      barre_menu.Append(sous_menu, "&Fichiers")
      # Deuxime sous-menu ... 
      sous_menu2 = wx.Menu()
      sous_menu2.Append(103, "&Rgles du jeu")
      sous_menu2.Append(104, "A &Propos")
      barre_menu.Append(sous_menu2, "&Aide")
      self.SetMenuBar(barre_menu)
      # Actions pour les menus
      self.Bind(wx.EVT_MENU, self.changement_questionnaire, id=101)
      self.Bind(wx.EVT_MENU, self.ciao, id=102)
      self.Bind(wx.EVT_MENU, self.regles_du_jeu, id=103)
      self.Bind(wx.EVT_MENU, self.a_propos, id=104)
      # Icones
      self.bmpsuper = wx.BitmapFromImage(wx.Image("super.png"))
      self.bmpbien = wx.BitmapFromImage(wx.Image("bien.png"))
      self.bmpbof = wx.BitmapFromImage(wx.Image("bof.png"))
      self.bmprate = wx.BitmapFromImage(wx.Image("rate.png"))
      # Elments graphiques
      self.score = wx.StaticText(self, wx.ID_ANY,
                                 str(self.bonnes_reponses) + '/'
                                 + str(self.nbr_questions))
      self.texte = wx.StaticText(self, wx.ID_ANY, 'Consigne')
      self.question = wx.StaticText(self, wx.ID_ANY, 'question')
      self.reponse_utilisateur = wx.TextCtrl(self)
      bouton = wx.Button(self, wx.ID_OK)
      self.bouton2 = wx.Button(self, wx.ID_ANY, "Solution")
      self.bouton2.Disable()
      # Rcupration des caractristiques visuelles
      carac = self.GetDefaultAttributes()
      taille_police = carac.font.GetPointSize()
      famille_police = carac.font.GetFamily()
      police_consigne = wx.Font(taille_police * 2,
                                famille_police, wx.NORMAL, wx.BOLD)
      police_question = wx.Font(int(taille_police * 1.5),
                                famille_police, wx.NORMAL, wx.NORMAL)
      carac2 = bouton.GetDefaultAttributes()
      self.SetBackgroundColour(carac2.colBg)
      self.texte.SetFont(police_consigne)
      self.question.SetFont(police_question)
      self.reponse_utilisateur.SetFont(police_question)
      # Icone
      self.smiley = wx.StaticBitmap(self, -1, self.bmpbof);
      # Disposition     
      self.boite = wx.BoxSizer(wx.VERTICAL)
      self.boite2 = wx.BoxSizer(wx.HORIZONTAL)
      boite3 = wx.BoxSizer(wx.HORIZONTAL)
      boite4 = wx.BoxSizer(wx.HORIZONTAL)
      # Rangement
      boite3.Add(self.smiley, flag=wx.ALL, border=10)
      boite3.Add(self.score, flag=wx.ALL, border=10)
      self.boite.Add(boite3, flag=wx.ALIGN_CENTER| wx.ALL, border=10)
      self.boite.Add(self.texte, flag=wx.ALIGN_CENTER| wx.ALL, border=10)
      self.boite2.Add(self.question)
      self.boite2.AddSpacer(10)
      self.boite2.Add(self.reponse_utilisateur)
      self.boite.Add(self.boite2, flag=wx.ALIGN_CENTER | wx.ALL, border=10)
      boite4.Add(bouton)
      boite4.AddSpacer(20)
      boite4.Add(self.bouton2)
      self.boite.Add(boite4, flag=wx.ALIGN_CENTER | wx.ALL, border=20)
      # Actions
      self.Bind(wx.EVT_BUTTON, self.verifier_reponse, bouton)
      self.Bind(wx.EVT_TEXT_ENTER, self.verifier_reponse, self.reponse_utilisateur)
      self.Bind(wx.EVT_BUTTON, self.donner_solution, self.bouton2)
      # Attachement de la disposition  la fentre
      self.SetSizer(self.boite)
      # Chargement
      try:
        self.chargement('questions.txt')
        self.nouvelle_question()
      except IOError:
        self.Destroy()

  def verifier_reponse(self, evenement):
       # Enlever une chance
       self.chances_restantes = self.chances_restantes - 1
       question_suivante = False
       reponse = self.reponse_utilisateur.GetValue().lower()
       reponse_ok = self.question_reponse.split(':')[1].lower()
       if enleve_accents(reponse) == enleve_accents(unicode(reponse_ok, 'cp1252')):
          if self.chances_restantes == 1 :
             self.bonnes_reponses = self.bonnes_reponses + 1
             self.smiley.SetBitmap(self.bmpsuper)
          else:
             self.bonnes_reponses = self.bonnes_reponses + 0.5
             self.smiley.SetBitmap(self.bmpbien)
          question_suivante = True
       else:
          self.smiley.SetBitmap(self.bmprate)
          if self.chances_restantes == 1 :  # Autoriser la solution
             self.bouton2.Enable()
          else:         # Donner la rponse 
             self.donner_solution(wx.MouseEvent())
       if question_suivante:
          self.score.SetLabel(str(self.bonnes_reponses) + '/'
                           + str(self.nbr_questions))
          self.nouvelle_question()
       else:
          self.reponse_utilisateur.Clear()
          self.reponse_utilisateur.SetFocus()
       
  def redimensionne(self):
      # On rcupre les dimensions de la question et
      # de la rponse, mises  ce que l'on peut trouver
      # de plus grand. SetSizeHints()fixe ensuite la taille
      # (premire paire = valeurs min, deuxime paire = valeurs max)
      larg, haut = self.question.GetSizeTuple()
      self.question.SetSizeHints(larg, haut, larg, haut)
      larg, haut = self.reponse_utilisateur.GetSizeTuple()
      self.reponse_utilisateur.SetSizeHints(larg, haut, larg, haut)
      # Recalcul
      self.boite2.Layout()
      self.boite.Layout()
      # Ajustement
      self.Fit()
      self.Centre()
      # Pour le gestionnaire de fentres ...
      self.SendSizeEvent()
      self.Refresh()
      
  def nouvelle_question(self):
      self.chances_restantes = 2
      self.bouton2.Disable()
      # Aller chercher une nouvelle question
      self.question_reponse = choice(self.questions)
      self.nbr_questions += 1
      self.question.SetLabel(self.question_reponse.split(':')[0] +'?')
      # Effacer la rponse prcdente
      self.reponse_utilisateur.Clear()
      # Positionner l o l'on doit rpondre
      self.reponse_utilisateur.SetFocus()
      
  def donner_solution(self, evenement):
      solution = self.question_reponse.split(':')[1]
      dialogue = wx.MessageDialog(self, 'La rponse est : ' + solution,
                               "Solution!",
                               wx.OK | wx.ICON_INFORMATION
                               )
      dialogue.ShowModal()
      dialogue.Destroy()
      self.smiley.SetBitmap(self.bmpbof)
      self.score.SetLabel(str(self.bonnes_reponses) + '/'
                          + str(self.nbr_questions))
      self.nouvelle_question()

  def chargement(self, nom_fichier):
      # Vrifier la longueur max des questions
      # et des rponses
      longueur_question_max = 0
      longueur_reponse_max = 0
      try:
        with open(nom_fichier, 'r') as f:
          consigne = f.readline().strip('\n')
          # On remet les questions  zro
          self.questions[:] = []
          for ligne in f:
            longueur = len(ligne.strip(' \n'))
            if longueur > 0:
              self.questions.append(ligne.strip(' \n'))
              longueur = len(ligne.strip(' \n').split(':')[0])
            if longueur > longueur_question_max :
              longueur_question_max = longueur
            longueur = len(ligne.strip(' \n').split(':')[1])
            if longueur > longueur_reponse_max :
              longueur_reponse_max = longueur
        # Rinitialisation des compteurs
        self.nbr_questions = 0
        self.bonnes_reponses = 0
        # Smiley "neutre"
        self.smiley.SetBitmap(self.bmpbof)
        self.texte.SetLabel(consigne)
        # Re-dimensionnement
        self.question.SetLabel('x' * longueur_question_max + '?')
        self.reponse_utilisateur.SetLabel('x' * longueur_reponse_max)
        self.redimensionne()
      except IOError as (errno, strerror):
        dialogue = wx.MessageDialog(self,
                            "Erreur de lecture fichier : " + strerror,
                            "Erreur!",
                            wx.OK | wx.ICON_ERROR)
        dialogue.ShowModal()
        dialogue.Destroy()
        raise IOError
      
  def regles_du_jeu(self, evenement):
    dialogue = wx.MessageDialog(self,
                                "Si votre rponse est fausse,"
                                + " vous avez une seconde chance"
                                + " qui peut vous rapporter un demi-point.",
                                "Les rgles du jeu",
                                wx.OK | wx.ICON_INFORMATION)
    dialogue.ShowModal()
    dialogue.Destroy()
  
  def a_propos(self, evenement):
    info = wx.AboutDialogInfo()
    info.Name = "Programme de quizz"
    info.Version = "1.0"
    info.Copyright = "Creative Commons/Paternit"
    info.Developers = [ "Pythonneries" ]
    wx.AboutBox(info)
  
  def changement_questionnaire(self, evenement):
      dialogue = wx.FileDialog(self,
                               message="Choisissez un questionnaire",
                               defaultDir=os.getcwd(), 
                               defaultFile="*.txt",
                               style=wx.FD_OPEN)

      if dialogue.ShowModal() == wx.ID_OK:
         # On rcupre une liste (rduite  un lment) de fichiers
         # choisis
         questionnaires = dialogue.GetPaths()
         self.chargement(questionnaires[0])
      dialogue.Destroy()
      self.nouvelle_question()

  def ciao(self, evenement):
      self.Destroy() 
 
class MonAppli(wx.App):
   def OnInit(self):
       fenetre = MaFenetre(None, -1, 'Programme de quizz')
       fenetre.Show()
       return True

app = MonAppli()
app.MainLoop()


