#include "ZString.h"

using namespace std;

ZString::ZString()
{
    m_chaine = NULL;
    m_longueur = 0;
}

ZString::ZString(const char *chaine)
{
    m_chaine = copie(chaine);
    m_longueur = longueur(chaine);
}

ZString::ZString(const ZString &chaine)
{
    m_chaine = copie(chaine.m_chaine);
    m_longueur = chaine.m_longueur;
}


ZString ZString::operator=(const char *chaine)
{
    delete[] m_chaine;
    m_chaine = copie(chaine);
    m_longueur = longueur(chaine);

    return *this;
}

ZString ZString::operator=(const ZString &chaine)
{
    delete[] m_chaine;
    m_chaine = copie(chaine.m_chaine);
    m_longueur = chaine.m_longueur;

    return *this;
}

ZString ZString::operator+(const char *chaine)
{
    int tailleTotale = m_longueur + longueur(chaine);
    char *sommeChaines = new char[tailleTotale + 1];

    for (int i = 0 ; i < longueur(m_chaine) ; i++)
    {
        sommeChaines[i] = m_chaine[i];
    }

    for (int i = m_longueur ; i < tailleTotale ; i++)
    {
        sommeChaines[i] = chaine[i - m_longueur];
    }
    sommeChaines[tailleTotale] = '\0';

    ZString resultat(sommeChaines);
    delete[] sommeChaines;
    return resultat;
}

ZString ZString::operator+(const ZString &chaine)
{
    int tailleTotale = m_longueur + chaine.m_longueur;
    char *sommeChaines = new char[tailleTotale + 1];

    for (int i = 0 ; i < longueur(m_chaine) ; i++)
    {
        sommeChaines[i] = m_chaine[i];
    }

    for (int i = m_longueur ; i < tailleTotale ; i++)
    {
        sommeChaines[i] = chaine.m_chaine[i - m_longueur];
    }
    sommeChaines[tailleTotale] = '\0';

    ZString resultat(sommeChaines);
    delete[] sommeChaines;
    return resultat;
}

ostream &operator<<( ostream &out, ZString &chaine )
{
    out << chaine.getChaine();
    return out;
}

char *ZString::getChaine()
{
    return m_chaine;
}

void ZString::afficher()
{
    cout << m_chaine << endl;
}

int ZString::longueur(const char *chaine)
{
    int i = 0;

    while (chaine[i] != '\0')
    {
        i++;
    }

    return i;
}

char *ZString::copie(const char *chaine)
{
    int taille = longueur(chaine);
    char *chaineCopie = new char[taille + 1];


    for (int i = 0 ; i < taille ; i++)
    {
        chaineCopie[i] = chaine[i];
    }
    chaineCopie[taille] = '\0';

    return chaineCopie;
}


ZString::~ZString()
{
    delete[] m_chaine;
}
