#include <SDL/SDL.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <cstdlib>

#include "sdlglutils.h"

#define FPS 50
#define LARGEUR_FENETRE 640
#define HAUTEUR_FENETRE 480

void DrawGL();

GLuint top,middle,bottom,motor; //les textures

int main(int argc, char *argv[])
{
    SDL_Event event;
    const Uint32 time_per_frame = 1000/FPS;
    unsigned int width = LARGEUR_FENETRE;
    unsigned int height = HAUTEUR_FENETRE;

    Uint32 last_time,current_time,elapsed_time; //for time animation
    Uint32 start_time,stop_time; //for frame limit

    SDL_Init(SDL_INIT_VIDEO);
    atexit(SDL_Quit);

    SDL_WM_SetCaption("SDL GL Application", NULL);
    SDL_SetVideoMode(width, height, 32, SDL_OPENGL);

    glMatrixMode( GL_PROJECTION );
    glLoadIdentity( );
    gluPerspective(70,(double)width/height,1,1000);

    glEnable(GL_DEPTH_TEST);
    glEnable(GL_TEXTURE_2D);

    top = loadTexture("rocket_top.jpg");
    middle = loadTexture("rocket_middle.jpg");
    bottom = loadTexture("rocket_bottom.jpg");
    motor = loadTexture("rocket_motor.jpg");

    last_time = SDL_GetTicks();
    for (;;)
    {

        start_time = SDL_GetTicks();


        while(SDL_PollEvent(&event))
        {
            switch(event.type)
            {
                case SDL_QUIT:
                exit(0);
                break;
                case SDL_KEYDOWN:
                switch (event.key.keysym.sym)
                {
                    case SDLK_p:
                    takeScreenshot("test.bmp");
                    break;
                    case SDLK_ESCAPE:
                    exit(0);
                    break;
                }
            }
        }

        current_time = SDL_GetTicks();
        elapsed_time = current_time - last_time;
        last_time = current_time;

        DrawGL();

        stop_time = SDL_GetTicks();
        if ((stop_time - last_time) < time_per_frame)
        {
            SDL_Delay(time_per_frame - (stop_time - last_time));
        }

    }

    return 0;
}

/* J'ai choisi de faire une fonction Dessiner Rocket.
Je pourrai ainsi l'appeler plusieurs fois, et dans n'importe quelle
position inititale du repre initiale */
void DrawRocket()
{
    glPushMatrix(); //pour que les transformations soient rversibles

    GLUquadric* params = gluNewQuadric(); //cration du quadrique
    gluQuadricTexture(params,GL_TRUE); //activation des coordonnes de texture

    glBindTexture(GL_TEXTURE_2D,top); //texture du haut
    gluCylinder(params,0.5,0,1.6,20,1); //cne 1

    glBindTexture(GL_TEXTURE_2D,middle);
    glTranslated(0,0,-1.05); //je descends pour faire le 2me cne
    gluCylinder(params,0.15,0.5,1.05,20,1); //cne 2

    glBindTexture(GL_TEXTURE_2D,bottom);
    glTranslated(0,0,-0.25); //je descens enfin tout en bas (sur le schma)
    gluCylinder(params,0.3,0.15,0.25,20,1); //cne 3

    //et  la mme position je dessin le disque de sortie des flammes
    glBindTexture(GL_TEXTURE_2D,motor);
    gluDisk(params,0,0.3,20,1); //disque 4

    gluDeleteQuadric(params); //je supprime le quadrique

    glPopMatrix(); //hop je remets tout comme je l'ai trouv
}

void DrawGL()
{
    glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity( );
    gluLookAt(3,4,2,0,0,0,0,0,1); //je place la camra a un endroit idal

    DrawRocket(); //je dessine la 1re roquette

    glTranslated(2,0,0); //je me dplace pour la 2me roquette
    glRotated(90,1,0,0); /*je vais tourner celle l pour que son axe principal
    soit horizontal */
    DrawRocket(); //et je la dessine

    glFlush();
    SDL_GL_SwapBuffers();
}

